<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Ticket extends Model 
{

    protected $table = 'tickets';
    public $timestamps = true;

    public function Category()
    {
        return $this->belongsTo('App\Models\Category');
    }

    public function TicketSteps()
    {
        return $this->hasMany('App\Models\TicketStep');
    }

    public function Clients()
    {
        return $this->hasMany('App\Models\Client');
    }

    public function Messages()
    {
        return $this->hasMany('App\Models\Message');
    }

    public function User()
    {
        return $this->belongsTo('App\Models\User');
    }

}